/* Antarmuka dengan Sensor Kelembaban Tanah dan Hujan - Trainer Internet of Things
 * Project : Monitoring dengan Sensor Kelembaban Tanah dan Hujan
 * Created By Electins.id
 * https://www.electins.id | https://www.instagram.com/electins.id/
 */

// Library ESP8266 WiFi dan Firebase ESP8266
#include <ESP8266WiFi.h>
#include <FirebaseESP8266.h>
// Library LCD 16x2 I2C
#include <Wire.h> 
#include <LiquidCrystal_I2C.h>

// SSID dan Password WiFi
#define WIFI_SSID "SSID_WIFI"
#define WIFI_PASSWORD "PASS_WIFI"

// URL Firebase dan Token Database
#define DATABASE_URL "project_id.firebaseio.com"
#define API_KEY "database_secret"

// PIN Analog Sensor (AS) terhubung ke PIN A0 NodeMCU
#define AS_PIN  A0

// Firebase objek dengan nama fbdo
FirebaseData fbdo;
// LCD Objek dengan nama lcd, alamat I2C 0x27, karakter 16x2
LiquidCrystal_I2C lcd(0x27,16,2);

// Nama pengguna pada Aplikasi IoT KIT
String user = "user_id";

// Variabel untuk menyimpan data ADC dan data konversi sensor
int as_adc, as_value;
// Variabel untuk menyimpan karakter data sensor
char as_data[3];

void setup() {
  // Serial Monitor pada baudrate 115200
  Serial.begin(115200);
  
  lcd.init();       // Inisialisasi LCD
  lcd.backlight();  // Menyalakan Backlight LCD
  lcd.print("Trainer Kit IoT");  // Menampilkan Teks pada LCD
  // Memulai koneksi WiFi
  WiFi.begin(WIFI_SSID, WIFI_PASSWORD);
  Serial.print("Connecting to Wi-Fi");
  while (WiFi.status() != WL_CONNECTED)
  {
    Serial.print(".");
    delay(300);
  }
  // Menampilkan status koneksi dan alamat IP
  Serial.println();
  Serial.print("Connected with IP: ");
  Serial.println(WiFi.localIP());
  Serial.println();
  
  // Menampilkan versi client firebase
  Serial.printf("Firebase Client v%s\n\n", FIREBASE_CLIENT_VERSION);
  // Memulai koneksi dengan dengan database
  // Re-koneksi jika WiFi terputus
  Firebase.begin(DATABASE_URL, API_KEY);
  Firebase.reconnectWiFi(true);
  
  delay(2000); // Jeda selama 2000ms atau 2 detik
  lcd.clear(); // Perintah untuk membersihkan tampilan LCD
}

void loop() { 
  // Membaca data ADC sensor
  // ADC disimpan pada 'as_adc'
  // Data konversi disimpan pada 'as_value'
  as_adc   = analogRead(AS_PIN);
  // Nilai 760 didapatkan dengan mencelupkan sensor ke air
  // Nilai *760 di ganti dengan nilai adc air
  // Ubah nilai *760 untuk sensor hujan
  as_value = map(as_adc, 0, 760, 0, 100);
  if(as_value > 100) as_value = 100;

  // Mencetak data pada serial monitor
  Serial.println("ADC   : " + String(as_adc));
  Serial.println("Nilai : " + String(as_value) + " %");
  Serial.println();

  // Mengirim data sensor ke database
  // dengan alamat *user/gauge1
  Firebase.setInt(fbdo, "/" + user + "/" + "gauge1", as_value);
  
  // Mencetak data sensor pada LCD 16x2 I2C
  lcd.setCursor(0,0); lcd.print("Analog Sens (%)");
  sprintf(as_data, "AS: %3d", as_value);
  lcd.setCursor(0,1);lcd.print(as_data);
  
  // Jeda 150 ms agar perubahan nilai lebih halus 
  delay(150); 
}
